# Load required packages
library(survival)
library(survminer)
library(readxl)

# Read Excel file
data <- read_excel("data_analysis5.1_202205.xlsx")

# Convert variable types
# Ensure AE is coded 0/1 where 1 = event occurred
data$Survival_status <- as.numeric(data$AE)

# Convert DHA to factor for grouping
# Example: if raw DHA is 0/1, you can set labels explicitly
# data$DHA <- factor(data$DHA, levels = c(0, 1), labels = c("Low DHA", "High DHA"))
data$DHA <- as.factor(data$DHA)

# Create a survival object
surv_obj <- Surv(time = data$Survival_time, event = data$Survival_status)

# Fit Kaplan–Meier survival curves by DHA group
fit <- survfit(surv_obj ~ DHA, data = data)

# Plot KM curves
ggsurvplot(
  fit,
  data = data,
  pval = TRUE,                 # show log-rank p-value
  conf.int = TRUE,             # show confidence interval
  risk.table = TRUE,           # show risk table
  legend.labs = c("Low DHA", "High DHA"),  # legend labels
  xlab = "Time (months)",
  ylab = "Probability of No AE",
  ggtheme = theme_minimal(),   # theme
  risk.table.height = 0.3,     # risk table height
  risk.table.fontsize = 4,     # risk table font size
  palette = c("#E05133", "#4877b9"),       # colors
  risk.table.y.text = FALSE    # hide left-side group labels in risk table
)
